;(async () => {
	// === 🔧 CONFIGURATION ===
	const tableRowSelector = 'creative-table table tr'
	const nextButtonSelector = '[aria-label="Next page"]'
	const nextButtonDisabledSelector = '[aria-label="Next page"][aria-disabled="true"]'
	const delayBetweenPages = 2000 // ms
	const maxPages = 350
	const spinnerId = 'table-copy-spinner-overlay'
	const popupId = 'table-copy-popup'

	// === 🎨 STYLE STRINGS ===
	const spinnerStyle = `position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.3);z-index:9999;display:flex;align-items:center;justify-content:center;font-size:1.5rem;color:white;font-family:sans-serif;`
	const popupHtml = `<div style="position:fixed;top:20px;right:20px;background:#28a745;color:white;padding:12px 20px;border-radius:8px;box-shadow:0 4px 8px rgba(0,0,0,0.2);font-family:sans-serif;z-index:10000;">✅ Table data downloaded as CSV!</div>`

	const delay = ms => new Promise(res => setTimeout(res, ms))
	let allData = []
	let currentPage = 1

	// === 🌀 Create Spinner Element ===
	const spinner = document.createElement('div')
	spinner.id = spinnerId
	spinner.setAttribute('style', spinnerStyle)
	spinner.textContent = `🔄 Extracting page ${currentPage}...`
	document.body.appendChild(spinner)

	// === 📊 Scrape paginated table data ===
	while (true) {
		const rows = [...document.querySelectorAll(tableRowSelector)].map(tr => [...tr.cells].map(td => `"${td.innerText.trim().replace(/"/g, '""')}"`).join(','))
		allData.push(...rows)

		const nextBtn = document.querySelector(nextButtonSelector)
		const isDisabled = document.querySelector(nextButtonDisabledSelector) !== null

		if (currentPage >= maxPages || !nextBtn || isDisabled) {
			spinner.textContent = `✅ Reached page ${currentPage}. Downloading...`
			break
		}

		currentPage++
		nextBtn.click()
		spinner.textContent = `🔄 Extracting page ${currentPage}...`
		await delay(delayBetweenPages)
	}

	// === 💾 Download as CSV ===
	const csvContent = allData.join('\n')
	const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' })
	const blobUrl = URL.createObjectURL(blob)
	const a = document.createElement('a')
	a.href = blobUrl
	a.download = 'table-data.csv'
	a.style.display = 'none'
	document.body.appendChild(a)
	a.click()
	a.remove()

	// === ✅ Show Success Popup ===
	const popup = document.createElement('div')
	popup.id = popupId
	popup.innerHTML = popupHtml
	document.body.appendChild(popup)
	setTimeout(() => popup.remove(), 4000)

	// === ❌ Remove Spinner ===
	document.getElementById(spinnerId)?.remove()
})()

